import { useState } from "react";
import { RegistrationForm } from "./components/RegistrationForm";
import { LoginForm } from "./components/LoginForm";
import { SearchPage } from "./components/SearchPage";
import { DiscoverPage } from "./components/DiscoverPage";
import { HotOrNotPage } from "./components/HotOrNotPage";
import { MatchesPage } from "./components/MatchesPage";
import { AdsPage } from "./components/AdsPage";
import { GroupsPage } from "./components/GroupsPage";
import { MessagesPage } from "./components/MessagesPage";
import { SubscriptionPage } from "./components/SubscriptionPage";
import { SimpleProfileSettingsPage } from "./components/SimpleProfileSettingsPage";
import { UserProfilePage } from "./components/UserProfilePage";
import { AdminControlPanel } from "./components/AdminControlPanel";
import { SuperAdminPanel } from "./components/SuperAdminPanel";
import { MemberVerificationPage } from "./components/MemberVerificationPage";
import { UserProvider } from "./components/UserProvider";
import { PointsProvider } from "./components/PointsProvider";
import { LandingPage } from "./components/LandingPage";
import { PrivacyPage } from "./components/PrivacyPage";
import { TermsPage } from "./components/TermsPage";
import { CookiesPage } from "./components/CookiesPage";
import { HelpCenterPage } from "./components/HelpCenterPage";
import { SafetyTipsPage } from "./components/SafetyTipsPage";
import { CommunityGuidelinesPage } from "./components/CommunityGuidelinesPage";
import { CookieConsent, useCookieConsent } from "./components/CookieConsent";
import { DynamicBackground } from "./components/DynamicBackground";
import { ThemeProvider } from "./components/ThemeProvider";
import { TranslationProvider, TranslationLoader } from "./components/TranslationProvider";
import { SubscriptionExpiryChecker } from "./components/SubscriptionExpiryChecker";
import { MediaProvider } from "./components/MediaManager";
import { ColorThemeProvider } from "./components/ColorThemeProvider";
import { Toaster } from "./components/ui/sonner";
import { GoogleMapsLoader } from "./components/GoogleMapsLoader";
import { useIsMobile } from "./components/ui/use-mobile";

// Mobile Components
import { MobileSearchPage } from "./components/mobile/MobileSearchPage";
import { MobileDiscoverPage } from "./components/mobile/MobileDiscoverPage";
import { MobileHotOrNotPage } from "./components/mobile/MobileHotOrNotPage";
import { MobileMatchesPage } from "./components/mobile/MobileMatchesPage";
import { MobileMessagesPage } from "./components/mobile/MobileMessagesPage";
import { MobileAdsPage } from "./components/mobile/MobileAdsPage";
import { MobileGroupsPage } from "./components/mobile/MobileGroupsPage";
import { MobileProfileSettingsPage } from "./components/mobile/MobileProfileSettingsPage";
import { MobileSubscriptionPage } from "./components/mobile/MobileSubscriptionPage";
import { MobileUserProfilePage } from "./components/mobile/MobileUserProfilePage";

export default function App() {
  const [currentView, setCurrentView] = useState<"login" | "register" | "landing" | "search" | "discover" | "hot-or-not" | "matches" | "ads" | "messages" | "groups" | "subscription" | "profile-settings" | "user-profile" | "admin-panel" | "super-admin" | "verification" | "privacy" | "terms" | "cookies" | "help-center" | "safety-tips" | "community-guidelines">("search");
  const { showConsent, openConsent, closeConsent } = useCookieConsent();
  const isMobile = useIsMobile();

  return (
    <ThemeProvider>
      <ColorThemeProvider>
        <TranslationProvider>
          <UserProvider>
            <PointsProvider>
              <MediaProvider>
                <GoogleMapsLoader>
      {/* Show main app pages */}
      {currentView === "landing" ? (
        <>
          <LandingPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "search" ? (
        <>
          {isMobile ? (
            <MobileSearchPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <SearchPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "discover" ? (
        <>
          {isMobile ? (
            <MobileDiscoverPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <DiscoverPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "hot-or-not" ? (
        <>
          {isMobile ? (
            <MobileHotOrNotPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <HotOrNotPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "matches" ? (
        <>
          {isMobile ? (
            <MobileMatchesPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <MatchesPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "ads" ? (
        <>
          {isMobile ? (
            <MobileAdsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <AdsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "groups" ? (
        <>
          {isMobile ? (
            <MobileGroupsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <GroupsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "messages" ? (
        <>
          {isMobile ? (
            <MobileMessagesPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <MessagesPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "subscription" ? (
        <>
          {isMobile ? (
            <MobileSubscriptionPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <SubscriptionPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "profile-settings" ? (
        <>
          {isMobile ? (
            <MobileProfileSettingsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <SimpleProfileSettingsPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "user-profile" ? (
        <>
          {isMobile ? (
            <MobileUserProfilePage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          ) : (
            <UserProfilePage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          )}
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "admin-panel" ? (
        <>
          <AdminControlPanel onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "super-admin" ? (
        <>
          <SuperAdminPanel onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "verification" ? (
        <>
          <MemberVerificationPage onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </>
      ) : currentView === "privacy" ? (
        <PrivacyPage onBack={() => setCurrentView("search")} />
      ) : currentView === "terms" ? (
        <TermsPage onBack={() => setCurrentView("search")} />
      ) : currentView === "cookies" ? (
        <CookiesPage onBack={() => setCurrentView("search")} onNavigate={setCurrentView} onOpenCookieConsent={openConsent} />
      ) : currentView === "help-center" ? (
        <HelpCenterPage onBack={() => setCurrentView("search")} />
      ) : currentView === "safety-tips" ? (
        <SafetyTipsPage onBack={() => setCurrentView("search")} />
      ) : currentView === "community-guidelines" ? (
        <CommunityGuidelinesPage onBack={() => setCurrentView("search")} />
      ) : (
        /* Show auth pages */
        <div className="min-h-screen relative flex items-center justify-center p-4">
          {/* Dynamic Background */}
          <DynamicBackground className="absolute inset-0 z-0" />
          
          {/* Content */}
          <div className="relative z-10 w-full max-w-4xl">
            <div className="bg-background/95 backdrop-blur-sm rounded-2xl p-8 shadow-2xl border border-border/20">
              {currentView === "login" ? (
                <LoginForm 
                  onSwitchToRegister={() => setCurrentView("register")}
                  onLoginSuccess={() => setCurrentView("search")}
                />
              ) : (
                <RegistrationForm 
                  onSwitchToLogin={() => setCurrentView("login")}
                  onRegistrationSuccess={() => setCurrentView("search")}
                />
              )}
            </div>
          </div>
          <CookieConsent isOpen={showConsent} onClose={closeConsent} onNavigate={setCurrentView} />
        </div>
      )}
            <TranslationLoader />
            <SubscriptionExpiryChecker />
            <Toaster />
                </GoogleMapsLoader>
              </MediaProvider>
            </PointsProvider>
          </UserProvider>
        </TranslationProvider>
      </ColorThemeProvider>
    </ThemeProvider>
  );
}