import { Heart, Mail, Phone, MapPin, Facebook, Twitter, Instagram, Youtube } from "lucide-react";
import { useTranslation } from "./TranslationProvider";

interface FooterProps {
  onNavigate?: (view: string) => void;
  onOpenCookieConsent?: () => void;
}

export function Footer({ onNavigate, onOpenCookieConsent }: FooterProps) {
  const { t } = useTranslation();
  
  return (
    <footer className="bg-gray-900 dark:bg-gray-950 text-white py-12">
      <div className="max-w-7xl mx-auto px-6">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {/* Brand Section */}
          <div className="space-y-4">
            <div className="flex items-center gap-2">
              <Heart className="w-6 h-6 text-purple-500 fill-purple-500" />
              <h3 className="text-xl font-semibold">SinglesZonne</h3>
            </div>
            <p className="text-gray-400 text-sm leading-relaxed">
              {t('footer.description')}
            </p>
            <div className="flex space-x-4">
              <a href="https://www.facebook.com/hotzonne" target="_blank" rel="noopener noreferrer">
                <Facebook className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors" />
              </a>
              <a href="https://www.x.com/hotzonne" target="_blank" rel="noopener noreferrer">
                <Twitter className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors" />
              </a>
              <a href="https://www.instagram.com/hotzonne" target="_blank" rel="noopener noreferrer">
                <Instagram className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors" />
              </a>
              <a href="https://www.youtube.com/hotzonne" target="_blank" rel="noopener noreferrer">
                <Youtube className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors" />
              </a>
              <a href="https://www.tiktok.com/@hotzonne" target="_blank" rel="noopener noreferrer">
                <svg className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors fill-current" viewBox="0 0 24 24">
                  <path d="M19.59 6.69a4.83 4.83 0 01-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 01-5.2 1.74 2.89 2.89 0 012.31-4.64 2.93 2.93 0 01.88.13V9.4a6.84 6.84 0 00-.88-.05A6.33 6.33 0 005 20.1a6.34 6.34 0 0010.86-4.43v-7a8.16 8.16 0 004.77 1.52v-3.4a4.85 4.85 0 01-1-.1z"/>
                </svg>
              </a>
              <a href="https://www.hotzonne.com" target="_blank" rel="noopener noreferrer">
                <Heart className="w-5 h-5 text-gray-400 hover:text-purple-500 cursor-pointer transition-colors fill-current" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div className="space-y-4">
            <h4 className="font-semibold text-white">Quick Links</h4>
            <ul className="space-y-2 text-sm">
              <li><a href="#" className="text-gray-400 hover:text-white transition-colors">Search</a></li>
              <li><a href="#" className="text-gray-400 hover:text-white transition-colors">Discover</a></li>
              <li><a href="#" className="text-gray-400 hover:text-white transition-colors">Messages</a></li>
              <li><a href="#" className="text-gray-400 hover:text-white transition-colors">Groups</a></li>
              <li><a href="#" className="text-gray-400 hover:text-white transition-colors">Premium</a></li>
            </ul>
          </div>

          {/* Support */}
          <div className="space-y-4">
            <h4 className="font-semibold text-white">Support</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <button 
                  onClick={() => onNavigate?.("help-center")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Help Center
                </button>
              </li>
              <li>
                <button 
                  onClick={() => onNavigate?.("safety-tips")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Safety Tips
                </button>
              </li>
              <li>
                <button 
                  onClick={() => onNavigate?.("community-guidelines")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Community Guidelines
                </button>
              </li>
              <li>
                <button 
                  onClick={() => onNavigate?.("privacy")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Privacy Policy
                </button>
              </li>
              <li>
                <button 
                  onClick={() => onNavigate?.("terms")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Terms of Service
                </button>
              </li>
              <li>
                <button 
                  onClick={() => onNavigate?.("cookies")}
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Cookie Policy
                </button>
              </li>
            </ul>
          </div>

          {/* Contact */}
          <div className="space-y-4">
            <h4 className="font-semibold text-white">Contact Us</h4>
            <div className="space-y-3 text-sm">
              <div className="flex items-center gap-3 text-gray-400">
                <Mail className="w-4 h-4" />
                <span>support@singleszonne.com</span>
              </div>
              <div className="flex items-center gap-3 text-gray-400">
                <Phone className="w-4 h-4" />
                <span>+1 (555) 123-4567</span>
              </div>
              <div className="flex items-center gap-3 text-gray-400">
                <MapPin className="w-4 h-4" />
                <span>123 Love Street, Romance City</span>
              </div>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-gray-800 mt-8 pt-8 flex flex-col md:flex-row justify-between items-center">
          <p className="text-gray-400 text-sm">
            Copyright © 2025 Hotzonne, Inc. All rights reserved.
          </p>
          <div className="flex space-x-6 mt-4 md:mt-0 text-sm">
            <button 
              onClick={() => onNavigate?.("privacy")}
              className="text-gray-400 hover:text-white transition-colors"
            >
              Privacy
            </button>
            <button 
              onClick={() => onNavigate?.("terms")}
              className="text-gray-400 hover:text-white transition-colors"
            >
              Terms
            </button>
            <button 
              onClick={() => onNavigate?.("cookies")}
              className="text-gray-400 hover:text-white transition-colors"
            >
              Cookies
            </button>
          </div>
        </div>
      </div>
    </footer>
  );
}