// Google Maps API Configuration
// This file centralizes all Google Maps API settings

export const GOOGLE_MAPS_CONFIG = {
  // API Key Configuration
  API_KEY: "YOUR_GOOGLE_MAPS_API_KEY",
  
  // Check if API key is properly configured
  get isConfigured() {
    return this.API_KEY && this.API_KEY !== "YOUR_GOOGLE_MAPS_API_KEY";
  },
  
  // Libraries to load
  LIBRARIES: ["places", "geometry"],
  
  // Default map settings
  DEFAULT_CENTER: { lat: 40.7128, lng: -74.0060 }, // New York City
  DEFAULT_ZOOM: 13,
  
  // Map styles
  MAP_STYLES: [
    {
      featureType: "poi",
      elementType: "labels",
      stylers: [{ visibility: "off" }]
    },
    {
      featureType: "transit",
      elementType: "labels", 
      stylers: [{ visibility: "off" }]
    }
  ],
  
  // Error handling
  get placeholderMessage() {
    return "Interactive map functionality available with Google Maps API";
  },
  
  get setupInstructions() {
    return `To enable Google Maps:
1. Get API key from Google Cloud Console
2. Enable Maps JavaScript API and Places API
3. Update API_KEY in GoogleMapsApiConfig.tsx
4. Restrict API key to your domain in production`;
  }
};

// Global check for Google Maps availability
export function isGoogleMapsAvailable(): boolean {
  return !!(window.google && window.google.maps && GOOGLE_MAPS_CONFIG.isConfigured);
}

// Silent error handling - returns whether maps should be enabled
export function shouldEnableMaps(): boolean {
  return GOOGLE_MAPS_CONFIG.isConfigured;
}

// Development mode check
export function isDevelopmentMode(): boolean {
  return !GOOGLE_MAPS_CONFIG.isConfigured;
}