// Google Maps API Configuration
// Replace "YOUR_GOOGLE_MAPS_API_KEY" with your actual Google Maps API key

export const GOOGLE_MAPS_CONFIG = {
  // Get your API key from: https://console.cloud.google.com/apis/credentials
  // Enable these APIs: Maps JavaScript API, Places API, Geocoding API
  API_KEY: "YOUR_GOOGLE_MAPS_API_KEY",
  
  // Default settings
  DEFAULT_ZOOM: 13,
  DEFAULT_CENTER: { lat: 40.7128, lng: -74.0060 }, // New York City
  
  // Map styling options
  STYLES: [
    {
      featureType: "poi",
      elementType: "labels",
      stylers: [{ visibility: "off" }]
    },
    {
      featureType: "transit",
      elementType: "labels", 
      stylers: [{ visibility: "off" }]
    }
  ]
};

// Check if API key is configured
export const isGoogleMapsConfigured = () => {
  return GOOGLE_MAPS_CONFIG.API_KEY !== "YOUR_GOOGLE_MAPS_API_KEY" && 
         GOOGLE_MAPS_CONFIG.API_KEY.length > 0;
};