import { useState } from "react";
import { Button } from "./ui/button";
import { Shield, RotateCcw } from "lucide-react";

interface ReCaptchaProps {
  onVerify: (verified: boolean) => void;
  verified: boolean;
}

export function ReCaptcha({ onVerify, verified }: ReCaptchaProps) {
  const [loading, setLoading] = useState(false);

  const handleVerify = async () => {
    setLoading(true);
    // Simulate ReCAPTCHA verification delay
    await new Promise(resolve => setTimeout(resolve, 2000));
    setLoading(false);
    onVerify(true);
  };

  const handleReset = () => {
    onVerify(false);
  };

  if (verified) {
    return (
      <div className="flex items-center justify-between p-4 border rounded-lg bg-green-50 border-green-200">
        <div className="flex items-center gap-2">
          <Shield className="w-5 h-5 text-green-600" />
          <span className="text-green-700">I'm not a robot ✓</span>
        </div>
        <Button 
          variant="ghost" 
          size="sm" 
          onClick={handleReset}
          className="text-green-600 hover:text-green-700"
        >
          <RotateCcw className="w-4 h-4" />
        </Button>
      </div>
    );
  }

  return (
    <div className="p-4 border rounded-lg bg-gray-50">
      <div className="flex items-center justify-between">
        <div className="flex items-center gap-2">
          <div className="w-6 h-6 border-2 border-gray-300 rounded"></div>
          <span className="text-gray-700">I'm not a robot</span>
        </div>
        <div className="flex flex-col items-center">
          <Shield className="w-8 h-8 text-gray-400" />
          <span className="text-xs text-gray-500">reCAPTCHA</span>
        </div>
      </div>
      <Button 
        onClick={handleVerify} 
        disabled={loading}
        className="w-full mt-3"
        variant="outline"
      >
        {loading ? "Verifying..." : "Verify"}
      </Button>
    </div>
  );
}